<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Include the centralized database config file
include 'config.php';

// Validate API key
$provided_api_key = isset($_GET['api_key']) ? $_GET['api_key'] : '';

if ($provided_api_key !== $api_key) {
    // Return error if API key is invalid
    http_response_code(401);  // Unauthorized
    die("Unauthorized access. Invalid API key.");
}

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Read POST data
$balance = isset($_POST['balance']) ? $conn->real_escape_string($_POST['balance']) : '';
$equity = isset($_POST['equity']) ? $conn->real_escape_string($_POST['equity']) : '';
$profit = isset($_POST['profit']) ? $conn->real_escape_string($_POST['profit']) : '';
$margin = isset($_POST['margin']) ? $conn->real_escape_string($_POST['margin']) : '';
$open_trades = isset($_POST['open_trades']) ? $conn->real_escape_string($_POST['open_trades']) : '';
$mt5username = isset($_POST['mt5username']) ? $conn->real_escape_string($_POST['mt5username']) : '';

// Generate timestamp
$timestamp = date('Y-m-d H:i:s');

// Check if the mt5username already exists in the userinfo table
$query = "SELECT id FROM userinfo WHERE mt5username='$mt5username'";
$result = $conn->query($query);

if ($result->num_rows > 0) {
    // If mt5username exists, update the existing record
    $row = $result->fetch_assoc();
    $id = $row['id'];

    $update_sql = "UPDATE userinfo 
                   SET balance='$balance', equity='$equity', profit='$profit', margin='$margin', open_trades='$open_trades', timestamp='$timestamp' 
                   WHERE id='$id'";

    if ($conn->query($update_sql) === TRUE) {
        echo "Record updated successfully";
    } else {
        echo "Error updating record: " . $conn->error;
    }
} else {
    // If mt5username does not exist, insert a new record
    $insert_sql = "INSERT INTO userinfo (balance, equity, profit, margin, open_trades, mt5username, timestamp) 
                   VALUES ('$balance', '$equity', '$profit', '$margin', '$open_trades', '$mt5username', '$timestamp')";

    if ($conn->query($insert_sql) === TRUE) {
        echo "New record created successfully";
    } else {
        echo "Error inserting record: " . $conn->error;
    }
}

// Error logging
error_log("Received data: " . print_r($_POST, true));

// Close connection
$conn->close();
?>